--=============================================================================
--      Setup
--=============================================================================    
USE Obfuscation

SET NOCOUNT ON 
--Supress the auto-display of rowcounts for appearance/speed

DECLARE @StartTime DATETIME    
--Timer to measure total duration    

SET @StartTime = GETDATE() --Start the timer

--=============================================================================
--      Create and populate a Tally table
--=============================================================================
--===== Conditionally drop      

IF OBJECT_ID('dbo.Tally') IS NOT NULL
    DROP TABLE dbo.Tally

--===== Create and populate the Tally table on the fly 
SELECT TOP 10000000
    IDENTITY(INT,1,1) AS N   
INTO dbo.Tally   
FROM master.dbo.SysColumns sc1,        
master.dbo.SysColumns sc2

--===== Add a Primary Key to maximize performance  
ALTER TABLE dbo.Tally    
    ADD CONSTRAINT pkTally
    PRIMARY KEY CLUSTERED (N) 
    WITH FILLFACTOR = 100

--===== Let the public use it  
GRANT SELECT, REFERENCES ON dbo.Tally TO PUBLIC

--===== Display the total duration 
SELECT STR(DATEDIFF(ms,@StartTime,GETDATE())) + ' Milliseconds duration'